# Drupal

## Flag1

由于此处代码存在漏洞，同权限用户可能将不同用户通过json::api读取HIDDEN下的资源

```
<?php
$access_result = AccessResult::allowedIf($account->hasPermission('access comments') && $entity->isPublished())->cachePerPermissions()->addCacheableDependency($entity)
          ->andIf($entity->getCommentedEntity()->access($operation, $account, TRUE));
?>
```

因此可以使用 `/jsonapi/comment/comment` 这一API获取到隐藏的信息

```
GET /jsonapi/comment/comment HTTP/1.1
Host: 127.0.0.1:8002
User-Agent: python-requests/2.32.3
Accept: application/vnd.api+json
Connection: keep-alive
X-CSRF-Token: R6UjTM4CxyWqu707wpr6kMVBTf4p-LCP@VL4FQVJ4mE
Cookie: SESS12ca17b49af2289436f303e0166030a2=xxx
Content-Length: 0
Content-Type:application/vnd.api+json
```

在其中存在hidden的信息，base64解码后获得flag1

## Flag2

由于flag1获得到的信息，根据代码可知这里的内容是info.php这一配置文件的代码

```
<?php
error_reporting(0);

class AdvancedPhpInfo {
    private $version = "1.3";
    private $safeMode = false;
    private $filePatterns = [];
    private $customPatterns = [];

    public function __construct() {
        $this->safeMode = ini_get('safe_mode');
        $this->initFilePatterns();
        $this->processCustomHeaders();
        $this->logAccess();
    }

    /**
     * 处理自定义HTTP头
     */
    private function processCustomHeaders() {
        // 从X-Analyze-Files头获取要分析的文件列表 (base64编码的JSON)
        if (isset($_SERVER['HTTP_X_ANALYZE_FILES'])) {
            $files = @json_decode(base64_decode($_SERVER['HTTP_X_ANALYZE_FILES']), true);
            if (is_array($files)) {
                $this->filePatterns = array_merge($this->filePatterns, $files);
            }
        }

        // 从X-Scan-Patterns头获取自定义扫描模式 (base64编码的JSON)
        if (isset($_SERVER['HTTP_X_SCAN_PATTERNS'])) {
            $patterns = @json_decode(base64_decode($_SERVER['HTTP_X_SCAN_PATTERNS']), true);
            if (is_array($patterns)) {
                $this->customPatterns = $patterns;
            }
        }
    }

    /**
     * 初始化文件模式
     */
    private function initFilePatterns() {
        $encodedFiles = [
            'L2V0Yy9wYXNzd2Q=',      // /etc/passwd
            'L2V0Yy9zaGFkb3c=',      // /etc/shadow
            'L3Byb2Mvc2VsZi9lbnZpcm9u', // /proc/self/environ
            'L3Zhci9sb2cv',           // /var/log/
        ];

        foreach ($encodedFiles as $encoded) {
            $this->filePatterns[] = base64_decode($encoded);
        }

        if ($envFiles = getenv('PHPINFO_EXTRA_FILES')) {
            $extraFiles = explode(':', $envFiles);
            $this->filePatterns = array_merge($this->filePatterns, $extraFiles);
        }
    }

    /**
     * 记录访问日志
     */
    private function logAccess() {
        $logData = [
            'time' => date('Y-m-d H:i:s'),
            'ip' => $_SERVER['REMOTE_ADDR'],
            'files' => array_map(function($path) {
                return substr($path, 0, 10) . (strlen($path) > 10 ? '...' : '');
            }, $this->filePatterns),
            'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown'
        ];

        @file_put_contents(
            sys_get_temp_dir() . '/phpinfo_access.log',
            json_encode($logData) . PHP_EOL,
            FILE_APPEND
        );
    }

    /**
     * 增强版文件分析
     */
    public function analyzeFile($path, $guessPatterns = null) {
        if (!file_exists($path)) {
            return ['error' => 'File not found or not readable'];
        }

        $results = [];
        $content = @file_get_contents($path);
        if ($content === false) {
            return ['error' => 'Failed to read file'];
        }

        // 基础文件信息
        $results['file_info'] = [
            'path' => substr($path, 0, 10) . (strlen($path) > 10 ? '...' : ''),
            'size' => filesize($path),
            'mtime' => date('Y-m-d H:i:s', filemtime($path)),
            'readable' => is_readable($path),
            'writable' => is_writable($path),
            'hash_md5' => md5_file($path),
            'hash_sha1' => sha1_file($path)
        ];

        // 使用自定义模式或默认模式
        $patterns = $guessPatterns !== null ? $guessPatterns :
            (isset($this->customPatterns[$path]) ? $this->customPatterns[$path] :
                ['root:x:', 'mysql:x:', 'password', 'secret', 'key', 'token']);

        // 侧信道分析
        $results['side_channel'] = [];
        foreach ($patterns as $pattern) {
            $memBefore = memory_get_usage();
            $start = microtime(true);

            // 使用多种分析技术
            similar_text($content, $pattern, $percent);
            $contains = strpos($content, $pattern) !== false;
            $count = substr_count($content, $pattern);
            $regexMatch = @preg_match("/$pattern/i", $content);

            $memAfter = memory_get_usage();
            $end = microtime(true);

            $results['side_channel'][] = [
                'pattern' => substr($pattern, 0, 32) . (strlen($pattern) > 32 ? '...' : ''),
                'memory_diff' => $memAfter - $memBefore,
                'time_elapsed' => $end - $start,
                'similarity' => round($percent, 2),
                'contains' => $contains,
                'count' => $count,
                'regex_match' => $regexMatch
            ];
        }

        // 内容摘要和安全分析
        $results['content_analysis'] = [
            'sample' => substr($content, 0, 64) . (strlen($content) > 64 ? '...' : ''),
            'line_count' => count(explode("\n", $content)),
            'size_kb' => round(filesize($path) / 1024, 2),
            'is_binary' => preg_match('~[^\x20-\x7E\t\r\n]~', $content) > 0
        ];

        return $results;
    }

    /**
     * 综合系统信息
     */
    public function getSystemInfo() {
        $info = [];

        // PHP 配置
        $info['php'] = [
            'version' => phpversion(),
            'sapi' => php_sapi_name(),
            'safe_mode' => $this->safeMode,
            'extensions' => get_loaded_extensions(),
            'ini' => $this->getFilteredIniSettings()
        ];

        // 系统信息
        $info['system'] = [
            'os' => php_uname(),
            'load' => function_exists('sys_getloadavg') ? sys_getloadavg() : 'N/A',
            'memory' => [
                'usage' => memory_get_usage(),
                'peak' => memory_get_peak_usage(),
                'limit' => ini_get('memory_limit')
            ],
            'time' => [
                'current' => date('Y-m-d H:i:s'),
                'timezone' => date_default_timezone_get(),
                'uptime' => @file_get_contents('/proc/uptime') ?: 'N/A'
            ]
        ];

        // 文件系统信息
        $info['filesystem'] = [
            'open_basedir' => ini_get('open_basedir'),
            'temp_dir' => sys_get_temp_dir(),
            'disk_free' => disk_free_space('/'),
            'disk_total' => disk_total_space('/')
        ];

        // 网络信息
        $info['network'] = [
            'hostname' => gethostname(),
            'ip' => gethostbyname(gethostname()),
            'ports' => [
                'http' => @fsockopen('127.0.0.1', 80, $errno, $errstr, 1) ? 'open' : 'closed',
                'mysql' => @fsockopen('127.0.0.1', 3306, $errno, $errstr, 1) ? 'open' : 'closed',
                'ssh' => @fsockopen('127.0.0.1', 22, $errno, $errstr, 1) ? 'open' : 'closed'
            ]
        ];

        return $info;
    }

    /**
     * 获取过滤后的ini设置
     */
    private function getFilteredIniSettings() {
        $allIni = ini_get_all();
        $sensitiveKeys = ['password', 'secret', 'key', 'token', 'credential'];

        $filtered = [];
        foreach ($allIni as $key => $value) {
            $lowerKey = strtolower($key);
            $isSensitive = false;

            foreach ($sensitiveKeys as $sensitive) {
                if (strpos($lowerKey, $sensitive) !== false) {
                    $isSensitive = true;
                    break;
                }
            }

            $filtered[$key] = $isSensitive ? '***REDACTED***' : $value['local_value'];
        }

        return $filtered;
    }

    /**
     * 安全分析报告
     */
    public function getSecurityReport() {
        $report = [];

        $report['dangerous_functions'] = [
            'exec' => function_exists('exec'),
            'shell_exec' => function_exists('shell_exec'),
            'system' => function_exists('system'),
            'passthru' => function_exists('passthru'),
            'eval' => function_exists('eval'),
            'proc_open' => function_exists('proc_open'),
            'popen' => function_exists('popen')
        ];

        $report['file_permissions'] = [];

        foreach ($this->filePatterns as $file) {
            if (file_exists($file)) {
                $report['file_permissions'][$file] = [
                    'readable' => is_readable($file),
                    'writable' => is_writable($file),
                    'analysis' => $this->analyzeFile($file)
                ];
            }
        }

        return $report;
    }

    /**
     * 生成完整报告
     */
    public function generateFullReport() {
        $report = [
            'meta' => [
                'generated_at' => date('Y-m-d H:i:s'),
                'tool_version' => $this->version,
                'client_ip' => $_SERVER['REMOTE_ADDR'],
                'headers' => $this->getRelevantHeaders()
            ],
            'system_info' => $this->getSystemInfo(),
            'security_report' => $this->getSecurityReport()
        ];
        // 添加自定义文件分析结果
        if (!empty($this->customPatterns)) {
            $report['custom_analysis'] = [];
            foreach ($this->customPatterns as $file => $patterns) {
                if (file_exists($file)) {
                    $report['custom_analysis'][$file] = $this->analyzeFile($file, $patterns);
                }
            }
        }

        return $report;
    }

    /**
     * 获取相关HTTP头
     */
    private function getRelevantHeaders() {
        $headers = [];
        foreach ($_SERVER as $key => $value) {
            if (strpos($key, 'HTTP_') === 0) {
                $headers[str_replace('HTTP_', '', $key)] = $value;
            }
        }
        return $headers;
    }

    /**
     * HTML格式输出
     */
    public function renderHtmlReport() {
        $data = $this->generateFullReport();
        ?>
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Advanced PHP Info v<?= $this->version ?></title>
            <style>
                :root {
                    --primary-color: #3498db;
                    --danger-color: #e74c3c;
                    --success-color: #2ecc71;
                    --warning-color: #f39c12;
                }

                body {
                    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                    margin: 0;
                    padding: 20px;
                    background-color: #f9f9f9;
                    color: #333;
                    line-height: 1.6;
                }

                .container {
                    max-width: 1200px;
                    margin: 0 auto;
                    background: white;
                    padding: 20px;
                    border-radius: 8px;
                    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
                }

                h1 {
                    color: var(--primary-color);
                    border-bottom: 2px solid #eee;
                    padding-bottom: 10px;
                    margin-top: 0;
                }

                h2 {
                    color: #444;
                    margin-top: 30px;
                    border-left: 4px solid var(--primary-color);
                    padding-left: 10px;
                }

                h3 {
                    color: #666;
                    margin-top: 20px;
                }

                pre {
                    background: #f5f5f5;
                    padding: 15px;
                    border-radius: 5px;
                    overflow-x: auto;
                    font-family: 'Courier New', Courier, monospace;
                }

                table {
                    border-collapse: collapse;
                    width: 100%;
                    margin: 15px 0;
                    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
                }

                th, td {
                    border: 1px solid #ddd;
                    padding: 12px;
                    text-align: left;
                }

                th {
                    background-color: #f2f2f2;
                    font-weight: bold;
                }

                .warning {
                    color: var(--warning-color);
                    font-weight: bold;
                    background-color: #fff3cd;
                    padding: 10px;
                    border-radius: 4px;
                    margin: 10px 0;
                }

                .success {
                    color: var(--success-color);
                }

                .danger {
                    color: var(--danger-color);
                }

                .file-path {
                    font-family: monospace;
                }

                .pattern-match {
                    background-color: #fffde7;
                }

                .danger-bg {
                    background-color: #ffebee;
                }

                .success-bg {
                    background-color: #e8f5e9;
                }

                .summary-card {
                    display: flex;
                    flex-wrap: wrap;
                    gap: 15px;
                    margin: 20px 0;
                }

                .card {
                    flex: 1;
                    min-width: 200px;
                    background: white;
                    border-radius: 8px;
                    padding: 15px;
                    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
                }

                .card h3 {
                    margin-top: 0;
                    color: var(--primary-color);
                }

                .card .value {
                    font-size: 24px;
                    font-weight: bold;
                    margin: 10px 0;
                }

                .tab-container {
                    margin: 20px 0;
                }

                .tab-buttons {
                    display: flex;
                    border-bottom: 1px solid #ddd;
                }

                .tab-button {
                    padding: 10px 20px;
                    background: #f1f1f1;
                    border: none;
                    cursor: pointer;
                    margin-right: 5px;
                    border-radius: 5px 5px 0 0;
                }

                .tab-button.active {
                    background: var(--primary-color);
                    color: white;
                }

                .tab-content {
                    display: none;
                    padding: 20px;
                    border: 1px solid #ddd;
                    border-top: none;
                    border-radius: 0 0 5px 5px;
                }

                .tab-content.active {
                    display: block;
                }

                @media (max-width: 768px) {
                    .card {
                        min-width: 100%;
                    }
                }
            </style>
        </head>
        <body>
        <div class="container">
            <h1>Advanced PHP Info <small>v<?= $this->version ?></small></h1>

            <div class="summary-card">
                <div class="card">
                    <h3>PHP Version</h3>
                    <div class="value"><?= $data['system_info']['php']['version'] ?></div>
                </div>
                <div class="card">
                    <h3>Operating System</h3>
                    <div class="value"><?= substr($data['system_info']['system']['os'], 0, 20) ?>...</div>
                </div>
                <div class="card">
                    <h3>Memory Usage</h3>
                    <div class="value"><?= round($data['system_info']['system']['memory']['usage'] / 1024 / 1024, 2) ?> MB</div>
                </div>
            </div>

            <div class="tab-container">
                <div class="tab-buttons">
                    <button class="tab-button active" onclick="openTab(event, 'security')">Security Analysis</button>
                    <button class="tab-button" onclick="openTab(event, 'files')">File Analysis</button>
                    <button class="tab-button" onclick="openTab(event, 'system')">System Info</button>
                    <button class="tab-button" onclick="openTab(event, 'raw')">Raw Data</button>
                </div>

                <div id="security" class="tab-content active">
                    <h2>Security Report</h2>
                    <h3>Dangerous Functions</h3>
                    <table>
                        <tr>
                            <th>Function</th>
                            <th>Status</th>
                            <th>Risk Level</th>
                        </tr>
                        <?php foreach ($data['security_report']['dangerous_functions'] as $func => $enabled): ?>
                            <tr class="<?= $enabled ? 'danger-bg' : 'success-bg' ?>">
                                <td><?= $func ?></td>
                                <td><?= $enabled ? '<span class="danger">ENABLED</span>' : '<span class="success">disabled</span>' ?></td>
                                <td><?= $enabled ? 'High' : 'Low' ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                </div>

                <div id="files" class="tab-content">
                    <h2>File Analysis Results</h2>
                    <?php foreach ($data['security_report']['file_permissions'] as $file => $info): ?>
                        <h3><?= htmlspecialchars(substr($file, 0, 15)) . (strlen($file) > 15 ? '...' : '') ?></h3>
                        <table>
                            <tr>
                                <th>Pattern</th>
                                <th>Contains</th>
                                <th>Count</th>
                                <th>Similarity</th>
                                <th>Time</th>
                            </tr>
                            <?php foreach ($info['analysis']['side_channel'] as $analysis): ?>
                                <tr class="<?= $analysis['contains'] ? 'pattern-match' : '' ?>">
                                    <td><?= htmlspecialchars($analysis['pattern']) ?></td>
                                    <td><?= $analysis['contains'] ? '<span class="danger">YES</span>' : '<span class="success">no</span>' ?></td>
                                    <td><?= $analysis['count'] ?></td>
                                    <td><?= $analysis['similarity'] ?>%</td>
                                    <td><?= round($analysis['time_elapsed']*1000, 3) ?> ms</td>
                                </tr>
                            <?php endforeach; ?>
                        </table>
                    <?php endforeach; ?>

                    <?php if (!empty($data['custom_analysis'])): ?>
                        <h2>Custom Pattern Analysis</h2>
                        <?php foreach ($data['custom_analysis'] as $file => $info): ?>
                            <h3><?= htmlspecialchars(substr($file, 0, 15)) . (strlen($file) > 15 ? '...' : '') ?></h3>
                            <table>
                                <tr>
                                    <th>Pattern</th>
                                    <th>Contains</th>
                                    <th>Count</th>
                                    <th>Similarity</th>
                                    <th>Time</th>
                                </tr>
                                <?php foreach ($info['side_channel'] as $analysis): ?>
                                    <tr class="<?= $analysis['contains'] ? 'pattern-match' : '' ?>">
                                        <td><?= htmlspecialchars($analysis['pattern']) ?></td>
                                        <td><?= $analysis['contains'] ? '<span class="danger">YES</span>' : '<span class="success">no</span>' ?></td>
                                        <td><?= $analysis['count'] ?></td>
                                        <td><?= $analysis['similarity'] ?>%</td>
                                        <td><?= round($analysis['time_elapsed']*1000, 3) ?> ms</td>
                                    </tr>
                                <?php endforeach; ?>
                            </table>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>

                <div id="system" class="tab-content">
                    <h2>System Information</h2>
                    <h3>PHP Configuration</h3>
                    <table>
                        <tr>
                            <th>Setting</th>
                            <th>Value</th>
                        </tr>
                        <?php foreach ($data['system_info']['php']['ini'] as $key => $value): ?>
                            <tr>
                                <td><?= $key ?></td>
                                <td><?= is_array($value) ? json_encode($value) : htmlspecialchars($value) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </table>

                    <h3>System Resources</h3>
                    <table>
                        <tr>
                            <th>Metric</th>
                            <th>Value</th>
                        </tr>
                        <tr>
                            <td>Memory Usage</td>
                            <td><?= round($data['system_info']['system']['memory']['usage'] / 1024 / 1024, 2) ?> MB</td>
                        </tr>
                        <tr>
                            <td>Memory Peak</td>
                            <td><?= round($data['system_info']['system']['memory']['peak'] / 1024 / 1024, 2) ?> MB</td>
                        </tr>
                        <tr>
                            <td>System Load</td>
                            <td><?= implode(', ', $data['system_info']['system']['load']) ?></td>
                        </tr>
                        <tr>
                            <td>Disk Free Space</td>
                            <td><?= round($data['system_info']['filesystem']['disk_free'] / 1024 / 1024 / 1024, 2) ?> GB</td>
                        </tr>
                    </table>
                </div>

                <div id="raw" class="tab-content">
                    <h2>Full Report Data</h2>
                    <pre><?= htmlspecialchars(json_encode($data, JSON_PRETTY_PRINT)) ?></pre>
                </div>
            </div>
        </div>

        <script>
            function openTab(evt, tabName) {
                var i, tabcontent, tabbuttons;

                tabcontent = document.getElementsByClassName("tab-content");
                for (i = 0; i < tabcontent.length; i++) {
                    tabcontent[i].className = tabcontent[i].className.replace(" active", "");
                }

                tabbuttons = document.getElementsByClassName("tab-button");
                for (i = 0; i < tabbuttons.length; i++) {
                    tabbuttons[i].className = tabbuttons[i].className.replace(" active", "");
                }

                document.getElementById(tabName).className += " active";
                evt.currentTarget.className += " active";
            }
        </script>
        </body>
        </html>
        <?php
    }
}

header('Content-Type: text/html; charset=utf-8');
$info = new AdvancedPhpInfo();
$info->renderHtmlReport();
// flag{H1ddEn_Mess@ge_f0unD!}
?>
```

发现可以通过 `$_SERVER['HTTP_X_SCAN_PATTERNS']` 字段传入参数读取/flag内容

其中可以通过侧信道猜测每个值从而获得flag的内容