import argparse
import zipfile
from pyzbar.pyzbar import decode
from PIL import Image

parser = argparse.ArgumentParser()
parser.add_argument('--gif', type=str, required=False, help='Path to the QR code GIF file')
parser.add_argument('--zip', type=str, required=False, help='Path to the ZIP file containing the GIF')
args = parser.parse_args()

if args.zip:
    zf = zipfile.ZipFile(args.zip, 'r')
    gif_file = zf.open('qr_animation.gif')
    gif = Image.open(gif_file)
else:
    assert args.gif is not None, "Either --gif or --zip must be provided"
    gif = Image.open(args.gif)

frames = []
try:
    while True:
        frames.append(gif.copy())
        gif.seek(len(frames))
except EOFError:
    pass

pixels = Image.new('1', frames[0].size, 1)
for frame in frames:
    pixels_frame = frame.convert('1')
    width, height = pixels_frame.size
    for x in range(width):
        for y in range(height):
            if pixels_frame.getpixel((x, y)) == 0:
                pixels.putpixel((x, y), 0)

decoded_objects = decode(pixels)
if decoded_objects:
    for obj in decoded_objects:
        print(obj.data.decode('utf-8'))