# 邮件日志分析-maillog



## 题目描述

小暗是一名学校的一名网络安全管理员，他的职责之一就是分析学校的邮件日志，发掘其中可能存在的恶意攻击事件。 

前几天，小暗在与同为网络安全管理员的小光吃饭时听闻，小光所在的学校发生了几起邮件攻击事件。小光把相关的攻击现象向小暗介绍了一番，小暗听后也是直冒冷汗。

为了排查问题、防微杜渐，小暗决定在自己学校的邮件日志中也排查一下这些攻击方式。但两个学校的邮件日志格式并不相同，这可让工作繁忙的小暗发起愁来了。聪明能干的你能帮帮他吗？


### 挑战目标

题目附件`maillog.tar.gz`中保存了一份Coremail 网页邮件服务器的日志文件，每行是一条日志内容，记录了用户的行为。


- `flag1`：请寻找邮件日志中，通过以下方式实施攻击的攻击者邮件账号：这位攻击者在窃取**多个**用户邮箱后，将这些邮箱的**二次验证**方法改为邮件认证，目标邮箱为攻击者的**同一个邮件账号**，从而持久掌控目标邮箱。你需要提交的flag就是`flag{攻击者的邮件账号}`。

- `flag2`：请寻找邮件日志中，通过以下方式实施攻击的攻击者邮件账号：这位攻击者在窃取**多个**用户邮箱后，为这些邮箱设置了**收件自动转发**，转发目标为攻击者的**同一个邮件账号**，从而隐蔽地窃取被盗账号的邮件。你需要提交的flag就是`flag{攻击者的邮件账号}`。

### 提示与注意事项


- 提示1：flag1、flag2对应的日志**操作类型**均非日志中**高频出现**的操作。其中flag1的行为可以从操作类型直接猜测，flag2则相对不明显，需要进一步分析请求参数名。
- 提示2：flag1中的攻击者，在攻击时也曾使用过flag2中“设置自动转发”的攻击方式。如果你有办法溯源flag1攻击者（对某个被盗账号）的完整行为，也许可以获得flag2的额外思路？
- 提示3：如果你对flag1、flag2的攻击操作对应的英文单词不熟悉，可以参考本题目的flag名称设置。（我可不保证他们真的会出现在日志当中，仅供参考）

- 日志已经按时间排序。
- 日志进行了脱敏处理，出现的IP、邮箱均非真实信息。题目中需要用到的邮箱账号（包括flag信息）满足邮件的基本格式，即用户名@域名。部分日志条目可能缺少信息，但不影响本题的作答。
- 题目保证flag1、flag2均有唯一解，但现实的邮件系统中就不一定了。

## 预期解法

### flag1

- flag1的提示挺明显的，只要跟随提示1的脚步，首先简单解析一下日志结构，写个代码统计一下操作类型 （func）。
- 提示说flag1的行为可以从操作类型直接猜测，那么就寻找含二次验证（`secondauth`）的行为（一共6个），挨个看一下就能找到关键函数`user:prepareUpdateSecondAuth`。
- 然后再去ctrl+F搜关键词人工就能分析出来，行数也不是很多。

### flag2 

- 提示3提示了转发的英文名称`forward`。但直接通过这个关键词搜索容易被`mbox:forwardMessages`操作给干扰，而且结果行数也比较多。
- 但在提示2的基础上，我们以flag1的攻击日志，通过进程唯一标识符sid找到攻击者的全部攻击路径，从这里进行寻找，就不会受到`mbox:forwardMessages`操作的干扰。从而发现关键的`setattrs`操作，可能包含请求参数：`forwarddes`（转发地址）。这就是攻击者的攻击行为pattern。
- 按照这个pattern可以轻松找到flag2。