import pyshark
import base64
import hashlib
import gzip
import zipfile
import io
import re
import argparse
from urllib.parse import unquote

parser = argparse.ArgumentParser()
parser.add_argument('--pcap', type=str, required=True, help='Path to the pcap file')
args = parser.parse_args()

PASS = "pass"
KEY = "key"
key = hashlib.md5(KEY.encode()).hexdigest()[0:16].encode()

def xor(data, key):
    from itertools import cycle, islice
    return bytes(a ^ b for a, b in zip(data, islice(cycle(key), 1, None)))

def decrypt_req(data):
    data = unquote(data)
    data = base64.b64decode(data)
    data = xor(data, key)
    try:
        data = gzip.decompress(data)
    except:
        pass
    return data

def decrypt_resp(data):
    start = hashlib.md5(PASS.encode() + key).hexdigest()[0:16]
    end = hashlib.md5(PASS.encode() + key).hexdigest()[16:32]
    assert data.startswith(start) and data.endswith(end)
    data = data[len(start):-len(end)]
    data = base64.b64decode(data)
    data = xor(data, key)
    data = gzip.decompress(data)
    return data

cap = pyshark.FileCapture(args.pcap, display_filter='http')

for packet in cap:
    if 'HTTP' in packet:
        http_layer = packet.http
        body = http_layer.file_data
        try:
            body_raw = bytes.fromhex(body.replace(':', ''))
        except ValueError:
            continue
        is_request = hasattr(http_layer, 'request_method')
        if is_request:
            body_raw = body_raw[len('pass='):]
            body = decrypt_req(body_raw.decode())
            if b'flag{' in body:
                regex = 'flag{.*?}'
                result = re.search(regex, body.decode())
                print("FLAG1:", result.group(0))
            else:
                print("Request Data:", body.decode())
        else:
            body = decrypt_resp(body_raw.decode())
            if body.startswith(b"PK\x03\x04"):
                with zipfile.ZipFile(io.BytesIO(body)) as z:
                    z.setpassword(b"www-data:/srv")
                    for name in z.namelist():
                        with z.open(name) as f:
                            content = f.read()
                            if b'flag{' in content:
                                regex = b'flag{.*?}'
                                result = re.search(regex, content)
                                print("FLAG2:", result.group(0).decode())
            else:
                print("Response Data:", body.decode())

cap.close()
