# 谁真正远程执行了命令？

## 题目描述

数字王国“皇家档案”网站遭遇海量攻击，安全团队导出了最近的 10000 条 Web 访问日志（access.log）。日志中包含：

- 各类混淆SQL注入、XSS、RCE等攻击
- 多种RCE尝试（包括CVEs、命令注入等），部分请求参数/路径/方法都很像，甚至有的携带了命令，但都未成功。
- 正常流量、爬虫、扫描器等。
- 部分RCE尝试日志虽然参数里有命令，但响应码/响应体/特征表明并未真正执行

**但仅有一条日志，真正实现了远程命令执行（RCE）！**

### 你的任务：

仔细分析 access.log，找出唯一一条“真正实现了远程命令执行”的 HTTP 请求。
提取该请求的 IP地址、时间（日志中的时间戳）、User-Agent，按 flag 格式提交。
注意事项：

- 日志中的IP地址已做随机替换，不具备溯源价值，请勿尝试分析IP与攻击行为的关联。
- 部分干扰项（如参数里有命令、cat /etc/passwd 等）并未真正执行，仅有一条响应码/体量/特征全部吻合。
- User-Agent不会包含明显的攻击/扫描器/Exploit字样，看起来像普通浏览器或工具。


### flag格式：
flag{md5(IP|时间|User-Agent)}

例如： md5(203.0.113.77|10/Jun/2024:14:23:51 +0000|Mozilla/5.0 (Windows NT 10.0; Win64; x64))=baefd966ccbfb9c5c27db9cdb80624a3 flag{baefd966ccbfb9c5c27db9cdb80624a3}

## 预期解法

按照题目提示进行筛选：
- 带有rce命令的url参数。
- User-Agent非模拟、不带有明显的攻击字样。
- 返回码为200，成功执行了rce。

以上条件即可唯一锁定攻击者了，当然还可以有很多其他的判断方式（返回内容长度等）。代码参见`exp.py`。