EXCLUDE_KEYWORDS = ['compatible', 'sql', 'rce']

def should_keep(line):
    # 判断User-Agent是否包含排除关键词
    if any(word in line.lower() for word in EXCLUDE_KEYWORDS):
        return False
    # 判断cmd和 200 是否在行内
    if 'cmd' in line.lower() and ' 200 ' in line:
        return True
    return False

with open('access.log', 'r', encoding='utf-8', errors='ignore') as fin, \
     open('filtered.log', 'w', encoding='utf-8') as fout:
    for line in fin:
        if should_keep(line):
            fout.write(line)

print('筛选完成，结果已输出到 filtered.log')