import string
import subprocess
import time
from concurrent.futures import ThreadPoolExecutor, as_completed

charset = string.ascii_letters + string.digits + '_?'
flag_len = 22
flag = ''

def test_char(known_flag, c):
    test_flag = known_flag + c  # 只用前缀+当前枚举字符
    start = time.time()
    p = subprocess.Popen(['python3', '-u', 'a.py'], stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    try:
        out, err = p.communicate(input=(test_flag + '\n').encode(), timeout=60)
    except subprocess.TimeoutExpired:
        p.kill()
        return c, float('inf')
    elapsed = time.time() - start
    print(f"Try {test_flag} -> {elapsed:.3f}s")
    return c, elapsed

for pos in range(flag_len):
    print(f"\n=== 爆破第 {pos+1} 位 ===")
    results = []
    with ThreadPoolExecutor(max_workers=8) as executor:  # 线程数可根据CPU调整
        futures = [executor.submit(test_char, flag, c) for c in charset]
        for future in as_completed(futures):
            c, elapsed = future.result()
            results.append((c, elapsed))
    # 选出最短时间的字符
    best_c, min_time = min(results, key=lambda x: x[1])
    print(f"第 {pos+1} 位爆破完成，最优字符：{best_c}，用时：{min_time:.3f}s")
    flag += best_c
    print(f"当前已爆破 flag: {flag}")

print(f"\n爆破全部完成！Final flag: {flag}")
