# 猜猜旗

## 题面

下发的口令验证系统采用了一种特殊的检查，只有输入正确的 flag 才能通过验证。

你的任务： 根据验证系统的响应，找出唯一正确的 flag。 直接输入正确的 flag 完成挑战。

下发文件：handout.zip（内含验证机制相关程序，可辅助理解响应）

## 预期解法

发放的文件是一个被PyArmor加密的工具，以及运行其所必备的运行时动态库。

运行后，发现程序要求输入flag。输出内容后，选手会发现程序在等待一段时间后，输出了长度过长/过短的提示。自然可以想到通过长度的枚举，先拿到flag的长度再说。可以知晓flag的长度为22.

在这个过程中，可以观察到，不同的输入会带来不同的等待时长，越长的输入等待越久。猜测是一个时间盲注的爆破攻击题目，且盲注时长与位数（错误的位数？）正相关。

选手需要想到排除额外的错误口令位对于当前枚举位的干扰，从长度为1的输入开始寻找正确的第一位，随后逐位爆破正确答案。

实际上，./src/a.py 给出了题目程序的原始代码。无论输入长度是否正确，代码都会将当前输入与实际 flag 进行对比，对于错误的情况进行睡眠。睡眠时长与相邻两位输入与 flag 的 ASCII 值异或结果有关。

由于是两位的结果同时影响睡眠长度，i+1位的错误可能会导致i位的正确结果睡眠时间反而更长，从而干扰爆破效果。

`./src/sol.py`给出了一个爆破的程序示例。事实上整体爆破速度不慢，符号集再大一些、不用多线程也能很快出答案。

